﻿<#
.SYNOPSIS

.PARAMETER installerPath, including the name of the installer, ex. C:\installs\AdluminInstaller.msi
.PARAMETER tenantId

.EXAMPLE .\adlumin_agent_uninstall_reinstall.ps1 -installerPath "C:\Windows\Temp\AdluminInstaller.msi" -tenantID "xxxxxxxxxxxxxx"
#>

[CmdletBinding()]
param(
    [Parameter(Mandatory)]
    [string]$installerPath,
    [Parameter(Mandatory)]
    [string]$tenantId
)

process {
    $serviceAdlumin = "Adlumin"
    $isAdluminRunning = $false
    $ableToUninstallAgent = $false

    function Check-Service {
        $service = Get-Service -Name $serviceAdlumin -ErrorAction SilentlyContinue
        if ($service -and $service.Status -eq "Running") {
            return $true
        } else {
            return $false
        }
    }

    function UninstallAgent {
            
        try {
            Start-Process -FilePath "msiexec.exe" -ArgumentList "/uninstall {904551C0-C463-4E7B-B54D-82F7D4EFE2F9} /qn /norestart" -Wait -NoNewWindow
        } catch {
            try {
                Start-Process -FilePath "msiexec.exe" -ArgumentList "/uninstall {904551C0-C463-4E7B-B54D-82F7D4EFE2F9} /qb /norestart" -Wait -NoNewWindow
            } catch {
                Write-Output "Unable to uninstall the agent"
                return $false
            }
        }

        return $true
    }

    function InstallAgent {


        Write-Output "Installing agent"
        Start-Process -FilePath "msiexec.exe" -ArgumentList "/i $installerPath tenant=$tenantId /qn" -Wait -NoNewWindow
    }


    # Check if Adlumin is running
    $isAdluminRunning = Check-Service

    Write-Output "Agent is running = $isAdluminRunning"
    
    if ($isAdluminRunning) {
        # Agent is running, uninstall it
        Write-Output "Uninstalling the agent"
        $ableToUninstallAgent = UninstallAgent
        Write-Output "Agent successfully uninstalled = $ableToUninstallAgent"
    }

    # Install agent
    InstallAgent
}




